//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-10: Leaching
//Example: 10.2 Page 517
//Title:  Feed rate of neutral water
//======================================================

model Ex10_2

//=============
// Parameter Section
 
parameter Real m[3](each unit="kg")={106,80,100} " Weight of Na2CO3, NaOH, CaCO3";
parameter Real per=0.01 " Final underflow concentration percent";

//=============
// Variable Section

Real x1" Concentration";
Real x2" Concentration";
Real x3" Concentration";
Real Wf (unit="kg") " Amount of water flowed";
Real W(unit="kg/s") " Actual flow rate of water required";

//=============
// Equation Section

equation

300*x3/100=per;
300*(x2-x3)/Wf=x3;
300*(x1-x3)/Wf=x2;
(80-300*(x3))/(600+Wf)=x1;
W=Wf*0.236/100;

//Answer is incorrect in the textbook due to incorrect division.
//The answer is 2.3 kg/s 

end Ex10_2;
//===============
