//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.15 Page 608
//Title:   Minimum reflux ratio
//======================================================

model Ex11_15

//=============
// Parameter Section
 
parameter Real F[4](each unit="kmol")={40,23,17,20} " Feed";
parameter Real D[4](each unit="kmol")={39,1,0,0} " Distillate";
parameter Real W[4](each unit="kmol")={1,22,17,20} " Bottoms";
parameter Real a[3]={2.7,2.22,1} " Relative Volatility";

//=============
// Variable Section

Real xf[4] " Mole fraction of feed";
Real xd[4] " Mole fraction of distillate";
Real xb[4] " Mole fraction of bottoms";
Real Td (unit="K") " Dew Point Temperature";
Real Ts (unit="K") " Still Temperature";
Real Tb (unit="K") " Boiling Point Temperature";
Real Tn (unit="K") " Upper pinch Temperature";
Real Tm (unit="K") " Lower pinch Temperature";
Real Tn1(unit="K") " New Upper pinch Temperature";
Real Tm1(unit="K") " New Lower pinch Temperature";
Real Rm " Minimum Reflux ratio";
Real Ln(unit="kmol") " Streams in the column for minimum reflux ratio";
Real Vn(unit="kmol") " Streams in the column for minimum reflux ratio";
Real Lm(unit="kmol") " Streams in the column for minimum reflux ratio";
Real Vm(unit="kmol") " Streams in the column for minimum reflux ratio";
Real rm1 " Value of rm";
Real rm2 " Value of rm";
Real psi " Value of psi";


//=============
// Equation Section

equation

for i in 1:4 loop
xf[i]=F[i]/sum(F);
xd[i]=D[i]/sum(D);
xb[i]=W[i]/sum(W);
end for;

Td=343;
Ts=416;
Tb=376;
Tn=Td+(1/3)*(Ts-Td);
Tm=Td+(2/3)*(Ts-Td);
Tn1=355;
Tm1=372;
Rm=1.08;
Ln=sum(D)*Rm;
Vn=Ln+sum(D);
Lm=Ln+sum(F);
Vm=Lm-sum(W); 
rm1=0.582/0.418;
rm2=0.424/0.272; 
psi=1/(1-0.119); 

end Ex11_15;
//===============
