//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.2 Page 549
//Title:  Saturated pressure
//======================================================

model Ex11_2
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real Tc(unit="K")=508.1 " Temperature";
parameter Real T1(unit="K")=329.026 " Temperature";
parameter Real T(unit="K")=350.874 " Temperature";
parameter Real Pc(unit="kPa")=4700 " Pressure";
parameter Real P1(unit="kPa")=100.666" Pressure";

//=============
// Variable Section

Real Tr1 (unit="k") " Temperature Tr1";
Real Tr2 (unit="k") " Temperature Tr2";
Real Pr1 (unit="kPa") " Pressure Pr1";
Real c1 " Constant c1";
Real c2 " Constant c2";
Real c5 " Constant c5";
Real k9 " Constant k9";
Real k10 " Constant k10";
Real k11 " Constant k11";
Real k12 " Constant k12";
Real P (unit="kPa") " Pressure";
Real Pf(unit="kPa") " Final Pressure";

//=============
// Equation Section

equation

Tr1=T1/Tc;
Pr1=P1/Pc;
c5=-35+36/Tr1+42*log(Tr1)-(Tr1^6);
c2=((0.315*c5)-log(Pr1))/(0.0838*c5-log(Tr1));
c1=0.0838*(3.758-c2);
k9=-35*c1;
k10=-36*c1;
k11=42*c1+c2;
k12=-c1;
Tr2=T/Tc;
log(P)=k9 - (k10/Tr2) + (k11*log(Tr2)) + (k12 * (Tr2^6));
Pf=P*Pc;

end Ex11_2;
//===============
