//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.6 Page 557
//Title:   Liquid and vapour phase mole fraction
//======================================================

model Ex11_6

//=============
// Parameter Section
 
parameter Real P(unit="kPa")=100 " Pressure ";
parameter Real f=0.25 " Fractional vaporisation";

//=============
// Variable Section

Real T(unit="K") " Temperature";
Real m " Slope of the line";
Real x " Liquid phase mole fraction";
Real y " Vapour phase mole fraction";

//=============
// Equation Section

equation

m=-(1-f)/f;

//From the Fig 11.9 on page 558

x=0.42;
y=0.63;
T=366.5;

end Ex11_6;
//===============
