//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.7 Page 564
//Title:  Number of theoretical plates
//======================================================

model Ex11_7

//=============
// Parameter Section
 
parameter Real F(unit="kmol")=100 " Feed";
parameter Real xt[8] ={0.79,0.644,0.492,0.382,0.298,0.208,0.120,0.048}" Value of xt from the equilibrium curve";
//parameter Real s;

//=============
// Variable Section

Real W (unit="kmol") " Bottoms";
Real D (unit="kmol") " Distillate";
Real Ln " Value of Ln";
Real Vn " Value of Vn";
Real Lm " Value of Lm";
Real Vm " Value of Vm";
Real yt[8] " Value of yt";
Real N " Number of plates";

//=============
// Equation Section

equation

F=W+D;
F*0.4=0.9*D+0.1*W;
Ln=3*D;
Vn=Ln+D;
Lm=Ln+F;
Vm=Lm-W;
yt[1]=0.9;

for i in 2:8 loop

if (i<5) then 

yt[i]=(xt[i-1]*Ln/Vn)+ (0.9*D/Vn);

else 

yt[i]=(xt[i-1]*Lm/Vm)- (0.1*W/Vm);

end if;

end for;

// Thus there will be 7 plates in the column

N=7;

end Ex11_7;
//===============
