//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.8 Page 567
//Title:  Number of theoretical plates by McCabe Thiele Method
//======================================================

model Ex11_8

//=============
// Parameter Section
 
parameter Real F(unit="kmol")=100 " Feed";
parameter Real xt[8] ={0.79,0.644,0.492,0.382,0.298,0.208,0.120,0.048}" Value of xt from the equilibrium curve";
//parameter Real s;

//=============
// Variable Section

Real W (unit="kmol") " Bottoms";
Real D (unit="kmol") " Distillate";
Real Ln " Value of Ln";
Real Vn " Value of Vn";
Real Lm " Value of Lm";
Real Vm " Value of Vm";
Real N " Number of plates";

//=============
// Equation Section

equation

F=W+D;
F*0.4=0.9*D+0.1*W;
Ln=3*D;
Vn=Ln+D;
Lm=Ln+F;
Vm=Lm-W;

// Top operating line equation
// yn=0.75xn+1  +  0.225

// Bottom operating line equation
// ym=1.415xm+1 - 0.042  

// After plotting graph and drawing we get no of plates to be 7

N=7;


end Ex11_8;
//===============
