//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-12: Absorption of Gases
//Example: 12.2 Page 671
//Title:  Mass Transfer Coefficient
//======================================================

model Ex12_2
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real G(unit="kg/sm^2")=2" Gas mass flow rate";
parameter Real D(unit="m^2/s")=0.116e-4 " Diffusivities of SO2";
parameter Real jd=0.02 " Friction factor";
parameter Real Re=5160 " Reynolds No";
parameter Real v1(unit="Pa s")=1.8e-5 " Viscosity of gas";
parameter Real p1(unit="kg/m^3")=1.154 " Density of gas";
parameter Real T(unit="K")=298 " Temperature";
parameter Real m(unit="kg/kmol")=64 " Molecular mass of SO2";

//=============
// Variable Section

Real kG(unit="kg SO2/sm^2 (kN/m^2)") " Liquid phase coefficient";
Real u(unit="m/s") " Velocity of gas";
Real hdp(unit="m/s") " Value of hdPbm/P";

//=============
// Equation Section

equation

G=p1*u;
(hdp/u)*((v1/(p1*D))^0.56)=jd;
kG=(hdp/(R*T))*m;

end Ex12_2;
//===============
