//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-12: Absorption of Gases
//Example: 12.3 Page 694
//Title:  Number of overall transfer units
//======================================================

model Ex12_3
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real G(unit="kg/sm^2")=1" Gas mass flow rate";
parameter Real L(unit="kg/sm^2")=1.6" Liquid mass flow rate";
parameter Real y1=0.015 " Mole fraction of gas at bottom of tower";
parameter Real m[2](each unit="kg/kmol")={18,29} " Molecular mass of water and air";

//=============
// Variable Section

Real Lm (unit="kg/m^2 s")" Liquid Molar flow rate";
Real Gm (unit="kg/m^2 s")" Gas Molar flow rate";
Real y2 "Mole fraction of gas at top of tower";
Real x1 "Mole fraction of liquid at bottom of tower";
Real ye1 " Equilibrium mole fraction";
Real Nog " NTU in gas";
Real Nol " NTU in liquid";
Real yLM " LM of y-ye";

//=============
// Equation Section

equation

Lm=L/18;
Gm=G/29;
y2=0.01*y1;
Gm*(y1-y2)=Lm*x1;
ye1=1.75*x1;
yLM=(y1-ye1-y2)/log((y1-ye1)/y2);
Nog=(y1-y2)/yLM;
Nol=Nog*1.75*Gm/Lm;

end Ex12_3;
//===============
