//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-14: Evaporation
//Example: 14.3 Page 794
//Title:  Efficiency of the compressor
//======================================================

model Ex14_3

//=============
// Parameter Section
 
parameter Real P[2](each unit="kPa")={1135,135} " Pressure in and out";
parameter Real H[2](each unit="kJ/kg")={2780,2375} " Enthalpy from chart";
parameter Real H3(unit="kJ/kg") =2640 " Enthalpy from chart";
parameter Real He(unit="kJ/kg") =2690 " Enthalpy of entrained steam ";
parameter Real m1(unit="kg")=1 " Mass of high pressure steam";
parameter Real m2(unit="kg")=1.6 " Mass of entrained steam";

//=============
// Variable Section

Real n " Efficiency";
Real H4 (unit="kJ/kg")" Enthalpy";

//=============
// Equation Section

equation

(m1*H[1])+(m2*He)=(m1+m2)*H4;
n=(m1+m2)*(H4-H3)/(m1*(H[1]-H[2]));

end Ex14_3;
//===============
