//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-14: Evaporation
//Example: 14.5 Page 796
//Title:  Capacity and economy of evaporator
//======================================================

model Ex14_5

//=============
// Parameter Section
 
parameter Real P[2](each unit="kPa")={650,205} " Pressures";
parameter Real BPR(unit="K") =10" Boiling point rise";
parameter Real T(unit="K") =295 " Feed inlet temperature";
parameter Real Ts(unit="K") =373 " Steam temperature";
parameter Real e1=0.95 " Nozzle efficiency";
parameter Real e2=0.8 " Momentum transfer efficiency";
parameter Real e3=0.9 " Compression efficiency";
parameter Real m1(unit="kg/s")=0.14 " Flow of steam";
parameter Real m2(unit="kg/s")=0.025 " Product withdrawal";
parameter Real H1(unit="kJ/kg")=2970 " Enthalpy";
parameter Real H2(unit="kJ/kg")=2605 " Enthalpy";
parameter Real x2=0.97 " Dryness fraction";
parameter Real LHvap(unit="kJ/kg")=2258 " Latent heat of vaporisation";
parameter Real LHvap0(unit="kJ/kg")=2200 " Latent heat of vaporisation";
parameter Real H3(unit="kJ/kg")=2675 " Enthalpy";
parameter Real H4(unit="kJ/kg")=2810 " Enthalpy";
parameter Real Cp(unit="kJ/kg K")=4.186 " Specific Heat";


//=============
// Variable Section

Real H21 (unit="kJ/kg")" Enthalpy";
Real x21 " Dryness after expansion before entrainment";
Real x22 " Dryness after expansion and entrainment";
Real m2m1 " Entrainment Ratio";
Real x3 " Final dryness";
Real D0 (unit="kg/s") " Flow of steam";
Real Gf (unit="kg/s") " Through put of the system";
Real D1 (unit="kg/s") " Vapour formed";
Real Economy " Economy of the system";

//=============
// Equation Section

equation

H1-H21=e1*(H1-H2);
(x21-x2)*LHvap=(1-e1)*(H1-H2);
(x22-x21)*LHvap=(1-e3)*(H1-H21);
m2m1=(((H1-H2)/(H4-H3))*e1*e2*e3)-1;
x3=(x2 +m2m1)/(1+m2m1);
D0=(m1*m2m1)+m1;
D0*LHvap0=((Gf*Cp)*(Ts-T))+(D1*LHvap);
Gf-D1=m2;
Economy=D1/m1;

end Ex14_5;
//===============
