//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-14: Evaporation
//Example: 14.6 Page 800
//Title:  Choice of compressor
//======================================================

model Ex14_6

//=============
// Parameter Section
 
parameter Real T[3](each unit="K")={312,287,278} " Temperatures";
parameter Real W(unit="kJ/kg") =150 " Work to compress ammonia";
parameter Real m(unit="kg/kg") =2.28 " Ammonia cycled";

// Diesel parameters
parameter Real Cv(unit="MJ/kg") =42 " Calorific value of diesel";
parameter Real dcost(unit="Great British Pound/kg") =0.02 " Cost of diesel";
parameter Real con(unit="kg/MJ of fuel") =0.4 " Consumption of diesel";

// Steam parameters
parameter Real scost(unit="Great British Pound/kg") =0.001 " Cost of steam";
parameter Real n =70 " Isentropic efficiency";
parameter Real P[2](each unit="kPa") ={700,101.3}" Steam pressures";
parameter Real H[2](each unit="kJ/kg")={2764,2676} " Enthalpy from chart";

//=============
// Variable Section

Real Wreq(unit="MJ/kg") " Work required";
Real Ereq(unit="MJ/kg") " Energy required from steam";
Real Es(unit="MJ/kg") " Energy from steam";
Real sreq(unit="kg/kg evaporation") " Steam required";
Real FC(unit="kg/kg water evaporated") " Fuel consumption";
Real Cost1(unit="Great British Pound/kg") " Total cost of using diesel";
Real Cost2(unit="Great British Pound/kg") " Total cost of using steam";

//=============
// Equation Section

equation

Wreq=W*m*1e-3;
FC=Wreq*con;
Cost1=dcost*FC;
Ereq=Wreq*100/n;
Es=(H[1]-H[2])*1e-3;
sreq=Ereq/Es;
Cost2=sreq*scost;

end Ex14_6;
//===============
