//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.7- Page 877
//Title:  Vapour pressure at 393K
//======================================================

model Ex15_7
extends Modelica.Math;
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real Pv[2](each unit="kPa")={0.78,0.22}" Vapour pressure of naphthalene at 463 and 433K";
parameter Real T[3](each unit="K")={463,433,393}" Temperatures";

//=============
// Variable Section

Real Lv(unit="kJ/mol") " Latent heat of vapourisation";
Real P(unit="kPa") " Pressure";

//=============
// Equation Section

equation

log(Pv[1]/Pv[2])=(Lv/R)*((1/T[2])-(1/T[1]));
log(Pv[2]/P)=(Lv/R)*((1/T[3])-(1/T[2]));

//Units used in the book are incorrect. Hence the pressure is 0.03 kPa

end Ex15_7;
//===============
