//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-16: Drying
//Example: 16.1- Page 909
//Title:  Time to dry
//======================================================

model Ex16_1
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real w1[2] (each unit="kg/kg")={0.25,0.3}" Value of w1";
parameter Real w[2](each unit="kg/kg")={0.1,0.08}" Value of w";
parameter Real wc(unit="kg/kg")=0.15" Critical Moisture";
parameter Real we(unit="kg/kg")=0.05" Equilibrium Moisture";
parameter Real t(unit="ks")=15 " Time to dry in first case";

//=============
// Variable Section

Real t2(unit="ks") " Time to dry in second case";
Real mA(unit="kg/ks") " Value of m*A"; 
Real f1[2](each unit="kg/kg") " Value of f1";
Real fc[2](each unit="kg/kg") " Value of fc";
Real f[2](each unit="kg/kg") " Value of f";

//=============
// Equation Section

equation

for i in 1:2 loop
f1[i]=w1[i]-we;
fc[i]=wc-we;
f[i]=w[i]-we;
end for;

t=(1/mA)*(((f1[1]-fc[1])/fc[1]) + log(fc[1]/f[1]));
t2=(1/mA)*(((f1[2]-fc[2])/fc[2]) + log(fc[2]/f[2]));

//Unit of mA is incorrect in the text

end Ex16_1;
//===============
