//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-17: Adsorption
//Example: 17.4 Page 1020
//Title:   Effluent concentration as function of time
//======================================================

model Ex17_4
extends Modelica.Math.Special;

//=============
// Parameter Section

parameter Real kg(unit="m/s") =0.0833 " Film mass transfer coefficient";
parameter Real T(unit="K")=300 " Temperature";
parameter Real P(unit="Pa")=1.024e5 " Pressure";
parameter Real p1p(unit="kg/m^3") =1266 " Density of particle";
parameter Real p1(unit="kg/m^3") =671 " Density of gel";
parameter Real dp(unit="m")=1.72e-3 " Diameter of particle";
parameter Real z(unit="m")=0.305 " Depth of packing";
parameter Real H(unit="kg water/kg dry air")=0.00267 " Humidity of air";
parameter Real G(unit="kg/m^2 s") =0.129 " Gas Flow rate";
parameter Real CCo[7]={0.024,0.045,0.079,0.24,0.5,0.715,0.92} " C/Co value";

//=============
// Variable Section

Real m " Constant m";
Real e " Voidage";
Real u(unit="m/s") " Velocity";
Real Ka " Constant Ka";
Real psilambda " Psi/Lambda value";
Real E[7] " Value of E";
Real TL[7] " Value of Tou*Lambda";
Real t[7](unit="hour") " Time";

//=============
// Equation Section

equation

m=(p1p-p1)/p1;
e=(p1p-p1)/p1p;
u=G/(e*1.186);
Ka=(kg/H)*(p1p/1.186);
psilambda=m*u*dp/(6*z*kg);

for i in 1:7 loop
CCo[i]=0.5*(1+erf(E[i]));
E[i]=((1.5*TL[i])-1)/(2*(psilambda^0.5));
t[i]=20.55*TL[i] + (1/2750);
end for;

end Ex17_4;
//===============
