//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-18: Ion Exchange
//Example: 18.2 Page 1072
//Title:  Concentration of nitric acid
//======================================================

model Ex18_2
extends Modelica.Constants;

//=============
// Parameter Section

parameter Real Naw(unit="kg/kgmol")=85 " Molecular weight of NaNO3";
parameter Real Hw(unit="kg/kgmol")=63 " Molecular weight of HNO3";
parameter Real p1(unit="kg/m^3")=1030 " Density";
parameter Real KNaH=1.5 " Value of KNa+ H+ from table 18.1";
parameter Real yna=0.1 " Ion concentration";

//=============
// Variable Section

Real c1(unit="kg/kgmol") " Concentration of NaNO3";
Real c2(unit="kg/kgmol") " Concentration of HNO3";
Real xna " Ion concentration";
Real p " Percentage";

//=============
// Equation Section

equation

c1=(20/Naw)*(p1/1000);
c2=(10*p/Hw)*(p1/1000);
xna=c1/(c1+c2);
yna/(1-yna)=KNaH*(xna/(1-xna));

end Ex18_2;
//===============
