//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-6: Fluidisation
//Example: 6.5 Page 349
//Title:  Heat transfer coefficient and Reynolds No and Nusselt No
//======================================================

model Ex6_5
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real d(unit="m")=0.25e-3 " Diameter";
parameter Real e =0.57" Bed Voidage";
parameter Real G(unit="kg/m^2 s")=0.2 " Gas flow rate";
parameter Real Cp(unit="kJ/kg K")=0.88 " Specific heat capacity";
parameter Real v1(unit="Pa s")=0.015e-3 " Viscosity";
parameter Real T[2](each unit="K") ={339.5,332.2} " Temperatures";
parameter Real Tz(unit="K m")=8.82e-3 " Area under the curve obtained";
parameter Real k(unit="W/mK") =0.03 " Thermal conductivity";

//=============
// Variable Section

Real Vp(unit="m^3") " Volume of particles";
Real Vp1(unit="m^3") " Volume of 1 particle";
Real Np(unit="No/m^3") " No of particles";
Real a (unit="m^2/m^3") " Area of particles";
Real Ht(unit="kW/m^2") " Heat transferred";
Real h[2](each unit="W/m^2K")" Heat transfer coefficient";
Real Re " Reynolds No"; 
Real Nu " Nusselt No";

//=============
// Equation Section

equation

Vp=(1-e);
Vp1=(pi/6)*(d^3);
Np=Vp/Vp1;
a=Np*(pi/4)*(d^2);
Ht=G*Cp*(T[1]-T[2]);
Ht=h[1]*a*Tz;
Re=G*d/v1;
Nu=0.11*(Re^1.28);
h[2]*d/k=Nu;

// Answer of a is incorrect in the book, thus h changes to 0.056W/m^2K

end Ex6_5;
//===============
