//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-7: Liquid Filtration
//Example: 7.4 Page 423
//Title:  Speed of the drum and mass of slurry
//======================================================
  
model Ex7_4
extends Modelica.Constants;

//=============
// Parameter Section

parameter Real t[2](each unit="s")={60,120} " Time";
parameter Real A(unit="m^2")=0.02 " Area of leaf filter";
parameter Real V[2](each unit="m^3")={0.0003,0.00044} " Volume collected";
parameter Real th(unit="m")=5e-3 " Thickness of cake";
parameter Real P(unit="kPa")=17 " Pressure";

//=============
// Variable Section

Real Lv " Constant L/v";
Real ruv (start=1e10)" Constant ruv";
Real t1(unit="s") " Time of submergence per revolution";
Real dP(unit="kPa") " Pressure difference";
Real BV(unit="m^3/rev") " Bulk volume deposited";
Real wt(unit="kg/rev") " Mass of filtrate per revolution";
Real Q(unit="m^3/s") " Filtrate production rate";
Real speed(unit="Hz") " Speed of rotation";
Real w(unit="kg/s") " Mass rate of filtrate production";
Real S(unit="kg/s") " Mass rate of solids";
Real mass(unit="kg/s") " Mass of slurry";

//=============
// Equation Section

equation

dP=101.325-P;
V[1]^2+2*Lv*A*V[1] = 2*dP*1e3*A^2*t[1]/ruv;
V[2]^2+2*Lv*A*V[2] = 2*dP*1e3*A^2*t[2]/ruv;
BV=4*pi*th;
4.4e-4*wt=0.063;
Q^2=1e-6*(wt^2);
Q^2+2*Lv*A*Q = 2*dP*1e3*(4*pi)^2*t1/ruv;
speed=0.4/t1;
w=wt*speed;
S=0.66*w;
mass=S+w;

end Ex7_4;
//===============
