//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-7: Liquid Filtration
//Example: 7.6 Page 426
//Title:  Number of frames and thickness of frame
//======================================================
  
model Ex7_6
extends Modelica.Constants;

//=============
// Parameter Section

parameter Real P(unit="kPa")=65 " Pressure";
parameter Real tr(unit="s")= 360" Time for 1 revolution";
parameter Real D(unit="m")=0.6 " Diameter";
parameter Real L(unit="m")=0.6 " Length";
parameter Real p1[2](each unit="kg/m^3") ={1000,3000} " Density";
parameter Real rate(unit="kg/s")=0.125 " Rate of filtration";
parameter Real voidage=0.5 " Voidage of bed";
parameter Real w(unit="kg")=0.2 " Weight of solids";

//=============
// Variable Section

Real A(unit="m^2") " Area";
Real V_rate(unit="m^3/s") " Volumetric rate of filtrate";
Real Solid_slurry(unit="m^3") " Volume of solids in slurry";
Real Filtrate(unit="m^3/kg") " Filtrate per kg of total slurry";
Real v " Volume of cake per unit volume of filtrate";
Real V_rate_solids(unit="m^3/s") " Volumetric rate of deposition of solids";
Real Bulk_volume(unit="m^3") " Bulk volume of cake deposited";
Real Th(unit="m") " Thickness of cake produced";
Real K " Value of K";
Real b(start=0.5,unit="m") " Thickness of filter press";
Real n " Minimum number of frames";
Real b1(start=0.047,unit="m") " Actual thickness of filter press";
Real b2(start=0.095,unit="m") " Actual thickness of filter press";
Real N " Number of frames";

//=============
// Equation Section

equation

A=pi*L*D;
V_rate=rate/p1[1];
Solid_slurry=0.2/p1[2];
Filtrate=((1/p1[1])-Solid_slurry);
v=(Solid_slurry*2)/Filtrate;
V_rate_solids=V_rate*v;
Bulk_volume=V_rate_solids*tr;
Th=Bulk_volume/A;
(V_rate*tr)^2=K*tr*0.2*P*1e3*A*A;
b^2-(0.0458*b)-0.001162=0;
n=(0.03+(25.8*b*b))/((0.629*b)-0.015);
6=(0.03+(25.8*b1*b1))/((0.629*b1)-0.015);
6=(0.03+(25.8*b2*b2))/((0.629*b2)-0.015);
N=6;

end Ex7_6;
//===============
