//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-7: Liquid Filtration
//Example: 7.7 Page 430
//Title:  Increase in overall throughput
//======================================================
  
model Ex7_7

//=============
// Parameter Section

parameter Real t[2](each unit="s")={600,3600} " Time";
parameter Real ts(unit="s")= 900" Time to empty and reset";
parameter Real tp(unit="s")= 180" Time to apply precoat";
parameter Real f(unit="m")=25e-3 " Frame thickness";
parameter Real th(unit="m")=1.6e-3 " Thickness of cake";
parameter Real P(unit="kPa")=415 " Pressure";

//=============
// Variable Section

Real totcycle_time(unit="s") " Total cycle time in first case";
Real t1(unit="s") " Time t1";
Real tt1(unit="s") " Time t-t1";
Real Cycle_time(unit="s") " Total cycle time in second case";
Real Inc " Percentage increase";

//=============
// Equation Section

equation

totcycle_time=t[1]+t[2]+ts;
t1=3300/4;
tt1=(19200/3)*(784-121+34)/2048;
Cycle_time=tp+ts+tt1+t1;
Inc=(0.000214-0.000196)*100/0.000196;

end Ex7_7;
//===============
