//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-8: Membrane separation process
//Example: 8.2 Page 460
//Title:  Membrane area
//======================================================

model Ex8_2
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real C[2](each unit="kg/m^3")={20,200}" Concentration";
parameter Real Vo(unit="m^3")=10 " Initial volume";
parameter Real V[5](each unit="m^3")={10,5,3,2,1}" Volumetric flow rate";
parameter Real t(unit="hour")=4" Time";

//=============
// Variable Section

Real AUC (unit="m^2/hour")" Area under curve";
Real A (unit="m^2")" Area of membrane";
Real y[5] (each unit="m/hour")" Y axis";
Real Jo(unit="m/hour")" Jo value";
Real Jf(unit="m/hour")" Jf value";
Real Jav(unit="m/hour")" J average value";
Real A_approx(unit="m^2")" Area of membrane using approximation";

//=============
// Equation Section

equation

Jo=0.04*log(250/C[1]);
Jf=0.04*log(250/C[2]);
Jav=Jf+0.27*(Jo-Jf);
A_approx=(9/t)/Jav;
for i in 1:5 loop
y[i]=(Jo-(0.04*log(Vo/V[i])))^(-1);
end for;

A=AUC/t;

algorithm
AUC:=0;
for i in 2:5 loop
AUC:=AUC+(0.5*(y[i]+y[i-1])*(V[i-1]-V[i]));
end for;


end Ex8_2;
//===============
