//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-8: Membrane separation process
//Example: 8.3 Page 462
//Title:  Number of membrane modules
//======================================================

model Ex8_3
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real C[2](each unit="kg/m^3")={0.5,20}" Concentration";
parameter Real Qo(unit="m^3/day")=50 " Flow rate";
parameter Real f(unit="m/hour")=0.04" Maximum flux";
parameter Real t(unit="hour")=20" Time";
parameter Real C1[3](each unit="kg/m^3")={5,4,4.5}" Concentration for two feed and bleed";

//=============
// Variable Section

Real Cl (unit="kg/m^3")" Concentration at which fouling limits";
Real A(unit="m^2")" Area for single feed and bleed";
Real A1[3](each unit="m^2")" 1st Area for two feed and bleed";
Real A2[3](each unit="m^2")" 2nd Area for two feed and bleed";

//=============
// Equation Section

equation

0.04=0.02*log(30/Cl);
2.438=A*0.02*log(30/C[2]);

for i in 1:3 loop
2.5=(1.25/C1[i])+(0.02*A1[i]*log(30/C1[i]));
A2[i]+A1[i]=87;
end for;

end Ex8_3;
//===============
