//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-1: Particulate Solids
//Example: 1.2 Page 14
//Title:   Surface and mass distribution curve and surface mean diameter
//======================================================

model Ex1_2
extends Modelica.Math; 

//=============
// Parameter Section
 
parameter Real n1=0 " Initial Value of n";
parameter Real d[3](each unit="micro m") ={0,10,100} " Diameter range";

//=============
// Variable Section

Real c1" Constant of integration";
Real c2 " Constant of integration";
Real n2 " Value of n";
Real d1(unit="micro m" ,start=0) " Diameter";
Real d2(unit="micro m" ,start=25)  " Diameter";
Real ds(unit="micro m") " Surface mean diameter";
Real n[9]" Value of n";

//=============
// Equation Section

equation

n1=0.5*(d[1]^2)+c1;
n2=0.5*(d[2]^2)+c1;
n2=c2-(0.33*1e5*(d[2]^(-3)));
ds=(((d[2]^5-d[1]^5)/5) + (1e5*(log(d[3]/d[2]))))/(((d[2]^4-d[1]^4)/4)+(1e5*(-1)*((d[3]^(-1))-(d[2]^(-1)) )));

algorithm
//Loop construct 1

for i in 1:5 loop
n[i]:=0.5*(d1^2);
d1:=d1+2.5;
end for;

//Loop construct 2

for i in 6:9 loop
n[i]:=c2-(0.33*1e5*(d2^(-3)));
d2:=d2+25;
end for;

end Ex1_2;
//===============
