//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-1: Particulate Solids
//Example: 1.3 Page 32
//Title:  Degree of mixing
//======================================================

model Ex1_3
extends Modelica.Math; 

//=============
// Parameter Section
 
parameter Real p=0.2 " Proportion of particles";
parameter Real n =100" No of particles";
parameter Real s[5]={0.025,0.006,0.015,0.018,0.019} " Sample Variance"; 

//=============
// Variable Section

Real so " Variance of unmixed sample";
Real sr" Variance of random mixture";
Real b[5] " Degree of mixing";

//=============
// Equation Section

equation

so=p*(1-p);
sr=p*(1-p)/n;

algorithm
//Loop construct 1

for i in 1:5 loop
b[i]:=(so-s[i])/(so-sr);
end for;

//From values of b we see maximum mixing occurs at t=60s

end Ex1_3;
//===============
