//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-1: Particulate Solids
//Example: 1.7 Page 79
//Title:  Estimation of particle size
//======================================================

model Ex1_7
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real dt(unit="m") =0.3" Diameter of cyclone";
parameter Real z(unit="m") =1.2" Length of cyclone";
parameter Real do(unit="m")=75e-3 " Inlet and Outlet Diameter";
parameter Real u(unit="m/s")=1.5 " Gas entry velocity";
parameter Real v1(unit="Pa s")=0.018e-3 " Air viscosity";
parameter Real p1air(unit="kg/m^3")=1.3 " Air density";
parameter Real p1p(unit="kg/m^3")=2700 " Particle density";

//=============
// Variable Section

Real Ai(unit="m^2") " Area";
Real G(unit="kg/s") " Mass flow of gas";
Real u0(unit="m/s") " Terminal Velocity of the smallest particle";
Real d(unit="m",start=1) " Diameter of the smallest particle using Stokes law";

//=============
// Equation Section

equation

Ai=(pi/4)*(do^2);
G=Ai*u*p1air;
u0=0.2*(Ai^2)*do*p1air*g_n/(pi*z*dt*G);
d=((18*v1*u0)/(g_n*(p1p-p1air)))^0.5;

end Ex1_7;
//===============
