//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-10: Leaching
//Example: 10.3 Page 524
//Title:  Required number of thickeners
//======================================================

model Ex10_3

//=============
// Parameter Section
 
parameter Real prod(unit="kg/s")=100 " Production rate of pigment";
parameter Real wat(unit="kg/s")=200 " Wash water rate";
parameter Real con1(unit="kg solute/kg pigment")=0.55 " Concentration of inlet solution";
parameter Real dis(unit="kg solvent/kg pigment")=0.5 " Concentration of outlet";
parameter Real conc[6](each unit="kg solute/kg soln")={0,0.1,0.2,0.3,0.4,0.5} " Concentration of solution";
parameter Real rem[6](each unit="kg soln/kg pigment")={0.3,0.32,0.34,0.36,0.38,0.4} " Amount of solution removed";
parameter Real solund(unit="kg/s")=50 " Solvent in underflow";
parameter Real Sn=0.001" Value of Sn";
parameter Real So=0.55" Value of So";
parameter Real Wo=1.00" Value of Wo";
parameter Real Wn=0.3007" Value of Wn";

//=============
// Variable Section

Real salt (unit="kg")" Amount of salt";
Real n " No of thickeners";
Real X1 " Concentration in the first thickener";
Real X2 " Concentration in the second thickener";
Real X3 " Concentration in the third thickener";
Real X4 " Concentration in the fourth thickener";
Real W1 " Value of W1";
Real S1 " Value of S1";
Real W2 " Value of W2";
Real S2 " Value of S2";
Real W3 " Value of W3";
Real S3 " Value of S3";
Real W4 " Value of W4";
Real S4 " Value of S1";

//=============
// Equation Section

equation

salt=solund*54.9/195;
(4-1)/(4^(n-1)-1)=0.1/salt;
X1=(So-Sn)/(2+Wo-Wn);
W1=0.3+0.2*(X1);
S1=W1*X1;
X2=(S1-Sn)/(1.7+W1);
W2=0.3+0.2*(X2);
S2=W2*X2;
X3=(S2-Sn)/(1.7+W2);
W3=0.3+0.2*(X3);
S3=W3*X3;
X4=(S3-Sn)/(1.7+W3);
W4=0.3+0.2*(X4);
S4=W4*X4;

//Thus S4 is less than Sn and therefore 4 thickeners are required.
// There are slight changes in the book values of X4,S4,W4 from that obtained due to truncation error.

end Ex10_3;
//===============
