//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-10: Leaching
//Example: 10.5 Page 536
//Title:  Number of theoretical stages
//======================================================

model Ex10_5

//=============
// Parameter Section
 
parameter Real Basis(unit="kg")=100 " Basis of untreated solids";
parameter Real solid(unit="kg oil/kg exhausted livers ")=0.35 " Solid charge";
parameter Real Conc[8](each unit="kg oil/kg solution")={0 ,0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.67} " Concentration of overflow "; 
parameter Real ent[8](each unit="kg solution/kg extracted livers")={0.28, 0.34, 0.40 ,0.47 ,0.55, 0.66, 0.80, 0.96} " Entrainment "; 
parameter Real ya=0.46 "Mass fraction";
parameter Real ys=0.54 "Mass fraction";

//=============
// Variable Section

Real RatioO[8](each unit="kg/kg liver") " Ratio of oil";
Real RatioE[8](each unit="kg/kg liver") " Ratio of ether";
Real RatioU[8](each unit="kg/kg liver") " Ratio of underflow";
Real xa[8] " Mass fraction";
Real xs[8] " Mass fraction";
Real ml(unit="kg") " Mass of livers fed";
Real xa1 " Mass fraction";
Real op(unit="kg") " Overflow product";
Real No " No of theoretical stages required";

//=============
// Equation Section

equation

for i in 1:8 loop
RatioO[i]=ent[i]*Conc[i];
RatioE[i]=ent[i]-RatioO[i];
RatioU[i]=1+ent[i];
xa[i]=RatioO[i]/RatioU[i];
xs[i]=RatioE[i]/RatioU[i];
end for;

ml=Basis/(1+solid);
xa1=(Basis-ml)/Basis;
op=50-(0.306*ml);

No=3;//Following the construction described in the text, it is found from Fig10.23 on page538

end Ex10_5;
//===============
