//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.1 Page 548
//Title:  Mole fraction in vapour & liquid phases
//======================================================

model Ex11_1

//=============
// Parameter Section
 
parameter Real T(unit="K")=373 " Temperature";
parameter Real Pt(unit="kPa")=101.3 " Total Pressure";
parameter Real Pv[2] (each unit="kPa")={106,73.7}" Vapour pressures of n-heptane and toluene"; 

//=============
// Variable Section

Real xA " Mole fraction of n-heptane in liquid phase";
Real yA " Mole fraction of n-heptane in vapour phase";

//=============
// Equation Section

equation

xA=(Pt-Pv[2])/(Pv[1]-Pv[2]);
yA=Pv[1]*xA/Pt;

end Ex11_1;
//===============
