//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.12 Page 595
//Title:   Amount of distillate and heat required
//======================================================

model Ex11_12

//=============
// Parameter Section
 
parameter Real F(unit="kmol")=100 " Basis of Feed";
parameter Real xd=0.75 " Percentage purity at distillate";
parameter Real R[6]={0.85,1,1.5,2,3,4} " Reflux ratio";
parameter Real xs[6]={0.55,0.5,0.37,0.2,0.075,0.05} " Value of xs";
parameter Real I[6]={0.405,0.375,0.3,0.25,0.187,0.15} " Value of intercept";

//=============
// Variable Section

Real Db[6](each unit="kmol") " Distillate";
Real RdB(unit="kmol") " Product of R and Db";
Real QR(unit="MJ") " Heat to be supplied to reflux";
Real Q (unit="MJ/kmol product") " Total heat ";

//=============
// Equation Section

algorithm

for i in 2:6 loop
RdB:=RdB+((0.5*(R[i]+R[i-1]))*(Db[i]-Db[i-1])); // Using Trapezoidal rule for numerical integration
end for;

equation

for i in 1:6 loop
Db[i]=F*(xs[1]-xs[i])/(xd-xs[i]);
end for;

QR=RdB*4000/1000;
Q=(QR/71.4)+4; //Slight variations exist due to difference in Numerical integral answer

end Ex11_12;
//===============
