//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.13 Page 596
//Title:   Average composition and heat required
//======================================================

model Ex11_13
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real F(unit="kmol")=100 " Basis of Feed";
parameter Real xd[6]={0.78,0.775,0.77,0.76,0.75,0.74} " Value of xd";
parameter Real R=2.1 " Reflux ratio";
parameter Real xs[6]={0.55,0.5,0.425,0.31,0.225,0.105} " Value of xs";

//=============
// Variable Section

Real xdxs[6](each unit="kmol") " Value of 1/(xd-xs)";
Real I" Value of integral obtained";
Real S1S2 " Ratio of S1 and S2";
Real Db(unit="kmol") " Amount of product obtained";
Real Eth(unit="kmol") " Amount of ethanol in product";
Real avg " Average composition of product"; 
Real Q (unit="kJ") " Total heat required for the flux";
Real Qkmol(unit="kJ/kmol") " Total heat required for the flux per kmol";

//=============
// Equation Section

algorithm

for i in 2:6 loop
I:=I+((0.5*(-xs[i]+xs[i-1]))*(xdxs[i]+xdxs[i-1])); // Using Trapezoidal rule for numerical integration
end for;

equation

for i in 1:6 loop
xdxs[i]=1/(xd[i]-xs[i]);
end for;

I=log(S1S2);
Db=F-F/S1S2;
Eth=(xs[1]*F) - (xs[6]*F/S1S2);
avg=Eth/Db;

Q=4000*R*Db; //Slight variations exist due to difference in Numerical integral answer
Qkmol=Q/Db;

end Ex11_13;
//===============
