//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.16 Page 612
//Title:   Minimum Reflux Ratio
//======================================================

model Ex11_16

//=============
// Parameter Section
 
 //Indices 1,2,3 indicate Hexane,Heptane,Octane respectively
 
parameter Real F[3](each unit="kmol")={40,35,25} " Feed";
parameter Real D[3](each unit="kmol")={40,34,1} " Products";
parameter Real W[3](each unit="kmol")={0,1,24} " Bottoms";
parameter Real a[3]={2.7,2.22,1} " Relative Volatility";
parameter Real xf[3]={0.4,0.35,0.25} " Mole fraction of feed";
parameter Real xd[3]={0.534,0.453,0.013} " Mole fraction of products"; 
parameter Real xw[3]={0,0.04,0.96} " Mole fraction of bottoms";
parameter Real theta=1.17" Value of theta";

//=============
// Variable Section

Real Rm " Minimum Reflux ratio";

//=============
// Equation Section

equation

((a[3]*xd[3])/(a[3]-theta))+((a[2]*xd[2])/(a[2]-theta))+((a[1]*xd[1])/(a[1]-theta))=Rm+1;

end Ex11_16;
//===============
