//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.20 Page 633
//Title:   Plate efficiency
//======================================================

model Ex11_20
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real xf[4]={0.2,0.3,0.2,0.3} " Mole fraction in feed";
parameter Real v1[4](each unit="Pa s")={0.048e-3,0.112e-3,0.145e-3,0.188e-3} " Viscosity";
parameter Real v1w(unit="Pa s")=1e-3 " Viscosity if water at 293K";

//=============
// Variable Section

Real sum " Sum of xf*v1l/v1w";
Real E " Efficiency "; 

//=============
// Equation Section

algorithm

for i in 1:4 loop

sum:=sum+xf[i]*v1[i]/v1w;

end for;

equation
E=0.17-0.616*log10(sum);

end Ex11_20;
//===============
