//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-11: Distillation
//Example: 11.9 Page 574
//Title:   Number of plates at total reflux
//======================================================

model Ex11_9
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real xf=0.4" Mole fraction in feed of benzene";
parameter Real xd=0.9" Mole fraction in distillate of benzene";
parameter Real xw=0.1" Mole fraction in bottoms of benzene";
parameter Real a=2.4 " Mean relative volatility of benzene w.r.t toluene";
parameter Real yf=0.61 " Value of yf from Fig 11.18";

//=============
// Variable Section

Real n " Number of plates";
Real Rm " Minimum Reflux Ratio";
Real Rmg " Minimum reflux ratio from graph";

//=============
// Equation Section

equation

n+1=(log10((xd/(1-xd))*((1-xw)/xw)))/log10(a);
Rm=(1/(a-1))*((xd/xf)-a*((1-xd)/(1-xf)));
Rmg=(xd-yf)/(yf-xf);

end Ex11_9;
//===============
