//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-12: Absorption of Gases
//Example: 12.4 Page 699
//Title:  Height of absorber and NTU
//======================================================

model Ex12_4
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real G(unit="kmol/s m^2")=0.015" Gas flow rate";
parameter Real y1=0.03 " Mole fraction of gas at bottom of tower";
parameter Real x1=0.013 " Mole fraction of liquid at bottom of tower";
parameter Real Kga(unit="kmol/s m^3")=0.04 " Mass transfer coefficient";

//=============
// Variable Section

Real y2 " Mole fraction of gas at top of tower";
Real ye1 " Equilibrium mole fraction";
Real yLM " LM of y-ye";
Real Z(unit="m") " Height of the column";
Real Hog " Height of transfer unit";
Real Nog " Number of transfer unit";

//=============
// Equation Section

equation

y2=0.01*y1;
G*(y1-y2)=Kga*yLM*Z;
ye1=2*x1;
yLM=(y1-ye1-y2)/log((y1-ye1)/y2);
Hog=G/Kga;
Nog=(Z/Hog);//NTU can thus be approximated to 21

end Ex12_4;
//===============
