//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-13: Liquid-liquid extraction
//Example: 13.1 Page 732
//Title:   Final raffinate composition
//======================================================

package Ex13_1

//=============

// Counter current operation

model Ex13_1a

//=============
// Parameter section 

parameter Real S(unit="cm^3/s")=160 " Solvent flow rate";
parameter Real Sol(unit="cm^3/s")=400 " Solution flow rate";
parameter Real p1[3](each unit="kg/m^3")={1200,1000,800} " Density ";
parameter Real AB[3](each unit="kg of A/kg of B")={0.05,0.1,0.15} " Equilibrium data";
parameter Real AS[3](each unit="kg of A/kg of S")={0.069,0.159,0.258} " Equilibrium data";

//=============

// Variable section

Real m(unit="kg/s") " Mass flow rate";
Real a(unit="m^3/s") " Concentration";
Real ma(unit="kg/s") " Mass flow rate of A";
Real mb(unit="kg/s") " Mass flow rate of B";  
Real Xf " Value of Xf";
Real slope " Value of slope";
Real Fr (unit="kg A/ kg B") " Final raffinate composition";

//=============
// Equation section
 
equation

m=S*1e-6*p1[3]; 
0.1=(1200*a)/(0.4+200*a);
ma=1200*a;
mb=0.4-1000*a;
Xf=ma/mb;
slope=mb/m;
Fr=0.057;

end Ex13_1a;


//=============
// Multi-stage operation

model Ex13_1b

//=============
// Parameter section 

parameter Real S(unit="cm^3/s")=160 " Solvent flow rate";
parameter Real Sol(unit="cm^3/s")=400 " Solution flow rate";
parameter Real p1[3](each unit="kg/m^3")={1200,1000,800} " Density ";
parameter Real AB[3](each unit="kg of A/kg of B")={0.05,0.1,0.15} " Equilibrium data";
parameter Real AS[3](each unit="kg of A/kg of S")={0.069,0.159,0.258} " Equilibrium data";
parameter Real A[3](each unit="kg/s")={0.0333, 0.0273,0.0224} " Value of A at every stage";

//=============
// Variable Section 

Real m(unit="kg/s") " Mass flow rate";
Real a(unit="m^3/s") " Concentration";
Real ma(unit="kg/s") " Mass flow rate of A";
Real mb(unit="kg/s") " Mass flow rate of B";  
Real Xf " Value of Xf";
Real X1 " Value of Xf";
Real X2 " Value of X2";
Real X3 " Final raffinate in multistage";

//=============
// Equation section
 
equation

m=S*1e-6*p1[3]; 
0.1=(1200*a)/(0.4+200*a);
ma=1200*a;
mb=0.4-1000*a;
Xf=ma/mb;
X1=A[1]/mb;
X2=A[2]/mb;
X3=A[3]/mb;

//=============

end Ex13_1b;


//=============

end Ex13_1;

//=============
