//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-13: Liquid-liquid extraction
//Example: 13.3 Page 740
//Title:   Overall transfer coefficient and Height of Transfer unit
//======================================================

model Ex13_3
extends Modelica.Math;

//=============
// Parameter Section
 
parameter Real H(unit="m")=1.4 " Height";
parameter Real CSA(unit="m^2")=0.0045 " Cross Sectional area";
parameter Real CW1(unit="kmol/m^3")=0.685 " Acid concentration in outlet";
parameter Real CW2(unit="kmol/m^3")=0.690 " Acid concentration in inlet";
parameter Real Cb1(unit="kmol/m^3")=0.004 " Benzene phase  concentration in inlet";
parameter Real Cb2(unit="kmol/m^3")=0.0115 " Benzene phase  concentration in inlet";
parameter Real F1(unit="m^3/s")=5.7e-6 " Flowrate of Benzene";
parameter Real F2(unit="m^3/m^2 s")=1.27e-3 " Flowrate of Benzene";

//=============
// Variable Section

Real moles " No of moles transferred";
Real CB1 (unit="kmol/m^3")" Value of CB1";
Real CB2 (unit="kmol/m^3") " Value of CB2";
Real dC2 (unit="kmol/m^3") " Driving force at top";
Real dC1 (unit="kmol/m^3") " Driving force at bottom";
Real Clm " Logarithmic driving force";
Real KBa(unit="kmol/s m^3(kmol/m^3)")" Mass transfer coefficient";
Real Hob(unit="m") " Height of transfer unit";

//=============
// Equation Section

equation

moles=F1*(Cb2-Cb1);
CB1=0.0247*CW1;
CB2=0.0247*CW2;
dC1=CB1-Cb1;
dC2=CB2-Cb2;
Clm=(dC1-dC2)/log(dC1/dC2);
KBa=moles/(CSA*H*Clm);
Hob=F2/KBa;

end Ex13_3;
//===============
