//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-14: Evaporation
//Example: 14.2 Page 782
//Title:  Area, temperature difference and steam consumption
//======================================================

package Ex14_2

//======================================================

model Ex14_2a

//Forward Feed Calculations

//=============
// Parameter Section

parameter Real Ps(unit="kPa")=205 " Pressure of saturated dry steam";
parameter Real P3(unit="kPa")=13 " Pressure of third effect evaporator";
parameter Real Lh0(unit="kJ/kg")=2200 " Latent heat ";
parameter Real Lh1(unit="kJ/kg")=2249 " Latent heat ";
parameter Real Lh2(unit="kJ/kg")=2293 " Latent heat ";
parameter Real Lh3(unit="kJ/kg")=2377 " Latent heat ";
parameter Real T0(unit="K")=394 " Temperature ";
parameter Real T1(unit="K")=376 " Temperature ";
parameter Real T2(unit="K")=359 " Temperature ";
parameter Real T3(unit="K")=325 " Temperature ";
parameter Real Tf(unit="K")=294 " Feed Temperature ";
parameter Real U[3](each unit="kW/m^2K") ={3.1,2,1.1} " Heat transfer coefficient";
parameter Real Gf(unit="kg/s") =4 " Liquor flow rate";
parameter Real Cp(unit="kJ/kg K")=4.186 " Specific heat of liquor";

//=============
// Variable Section

Real dT1(unit="K") " Temperature difference";
Real dT2(unit="K") " Temperature difference";
Real dT3(unit="K") " Temperature difference";
Real D0(unit="kg/s") " Amount of steam";
Real D1(unit="kg/s") " Amount of vapour in 1st effect";
Real D2(unit="kg/s") " Amount of vapour in 2nd effect";
Real D3(unit="kg/s") " Amount of vapour in 3rd effect";
Real A1(unit="m^2") " Area of first effect";
Real A2(unit="m^2") " Area of second effect";
Real A3(unit="m^2") " Area of third effect";
Real e (unit="kg/kg")" Economy of steam";

//=============
// Equation Section

equation

dT1=18;
dT2=17;
dT3=34;
Lh0*D0=Gf*Cp*(T1-Tf)+ (D1*Lh1);
(D1*Lh1)+((Gf-D1)*Cp*(T1-T2))=D2*Lh2;
(D2*Lh2)+((Gf-D1-D2)*Cp*(T2-T3))=D3*Lh3;
D1+D2+D3=3.2;
A1=D0*Lh0/(U[1]*dT1);
A2=D1*Lh1/(U[2]*dT2);
A3=D2*Lh2/(U[3]*dT3);
e=3.2/D0;

end Ex14_2a;


//=============

//======================================================

model Ex14_2b

//Backward Feed Calculations

//=============
// Parameter Section

parameter Real Ps(unit="kPa")=205 " Pressure of saturated dry steam";
parameter Real P3(unit="kPa")=13 " Pressure of third effect evaporator";
parameter Real Lh0(unit="kJ/kg")=2200 " Latent heat ";
parameter Real Lh1(unit="kJ/kg")=2254 " Latent heat ";
parameter Real Lh2(unit="kJ/kg")=2314 " Latent heat ";
parameter Real Lh3(unit="kJ/kg")=2377 " Latent heat ";
parameter Real T0(unit="K")=394 " Temperature ";
parameter Real T1(unit="K")=374 " Temperature ";
parameter Real T2(unit="K")=350 " Temperature ";
parameter Real T3(unit="K")=325 " Temperature ";
parameter Real Tf(unit="K")=294 " Feed Temperature ";
parameter Real U[3](each unit="kW/m^2K") ={2.5,2.0,1.6} " Heat transfer coefficient";
parameter Real Gf(unit="kg/s") =4 " Liquor flow rate";
parameter Real Cp(unit="kJ/kg K")=4.186 " Specific heat of liquor";

//=============
// Variable Section

Real dT1(unit="K") " Temperature difference";
Real dT2(unit="K") " Temperature difference";
Real dT3(unit="K") " Temperature difference";
Real D0(unit="kg/s") " Amount of steam";
Real D1(unit="kg/s") " Amount of vapour in 1st effect";
Real D2(unit="kg/s") " Amount of vapour in 2nd effect";
Real D3(unit="kg/s") " Amount of vapour in 3rd effect";
Real A1(unit="m^2") " Area of first effect";
Real A2(unit="m^2") " Area of second effect";
Real A3(unit="m^2") " Area of third effect";
Real e (unit="kg/kg")" Economy of steam";

//=============
// Equation Section

equation

dT1=20;
dT2=24;
dT3=25;
(D3*Lh3)+(Gf*Cp*(T3-Tf))=D2*Lh2;
(D2*Lh2)+((Gf-D3)*Cp*(T2-T3))=D1*Lh1;
(Gf-D3-D2)*Cp*(T1-T2)+ (D1*Lh1)=Lh0*D0;
D1+D2+D3=3.2;
A1=D0*Lh0/(U[1]*dT1);
A2=D1*Lh1/(U[2]*dT2);
A3=D2*Lh2/(U[3]*dT3);
e=3.2/D0;

end Ex14_2b;

//=============


//=============

end Ex14_2;

//======================================================
