//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-14: Evaporation
//Example: 14.7 Page 803
//Title:  Optimum boiling costs
//======================================================

model Ex14_7

//=============
// Parameter Section
 
parameter Real dT(each unit="K")=40 " Temperature difference";
parameter Real C_Shutdown(unit="Great British Pound") =600 " Shutdown cost";
parameter Real C_boil(unit="Great British Pound/s") =18e-3 " Operating cost during boiling";
parameter Real tc(unit="s") =15e3 " Downtime for cleaning";
parameter Real Lh(unit="kJ/kg") =2300 " Latent Heat ";
parameter Real A(unit="m^2")=40 " Area ";
parameter Real a=7e-5 " Constant a";
parameter Real b=0.2" Constant b";

//=============
// Variable Section

Real tb[2](each unit="s") " Boiling time to give maximum heat transfer";
Real Q[2](each unit="kJ") " Heat transferred during boiling";
Real w[2](each unit="kg") " Water vaporated";
Real evap_rate[2](each unit="kg") " Rate of evaporation";
Real mean_evap_rate[2](each unit="kg") " Mean rate of evaporation";
Real Costcycle[2](each unit="Great British Pound/cycle") " Cost of per cycle";
Real Cost[2](each unit="Great British Pound/kg") " Cost of per kg";

//=============
// Equation Section

// Array indices 1 and 2 indicate maximum and minimum costs respectively

equation

tb[1]= tc + (2/a)*((a*b*tc)^ 0.5);
Q[1] = (2*A*dT/a)*((((a*tb[1]) + b)^ 0.5) - (b^ 0.5));
w[1]=Q[1]/Lh;
evap_rate[1]=w[1]/tb[1];
mean_evap_rate[1]=w[1]/(tb[1]+tc);
Costcycle[1]=(tb[1]*C_boil)+C_Shutdown;
Cost[1]=Costcycle[1]/w[1];

tb[2]=(C_Shutdown /C_boil ) + 2*(a*b*C_Shutdown*C_boil)^0.5 /(a*C_boil ) ;
Q[2] = (2*A*dT/a)*((((a*tb[2]) + b)^ 0.5) - (b^ 0.5));
w[2]=Q[2]/Lh;
evap_rate[2]=w[2]/tb[2];
mean_evap_rate[2]=w[2]/(tb[2]+tc);
Costcycle[2]=(tb[2]*C_boil)+C_Shutdown;
Cost[2]=Costcycle[2]/w[2];

end Ex14_7;
//===============
