//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.2 Page 839
//Title:  Increase in solubility
//======================================================

model Ex15_2
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real T(unit="K")=298 " Temperature"; 
parameter Real r[3](each unit="micro m")={0.5,0.05,0.005}" Diameter of particles";
parameter Real m[2](each unit="kg/kmol")={233,342}" Relative molecular mass for BaSO4 and Sucrose";
parameter Real n[2]={2,1}" Number of ions for BaSO4 and Sucrose";
parameter Real p1[2](each unit="kg/m^3")={4500,1590}" Solid density for BaSO4 and Sucrose";
parameter Real it[2](each unit="J/m^2")={0.13,0.01} " Interfacial Tension for BaSO4 and Sucrose";

//=============
// Variable Section

Real CCB[3] " Cr/ C Value for BaSO4";
Real CCS[3] " Cr/ C Value for Sucrose";
Real pB[3] " Percent increase in BaSO4";
Real pS[3] " Percent increase in Sucrose";

//=============
// Equation Section

equation

for i in 1:3 loop
CCB[i]=e^((2*m[1]*it[1])/(n[1]*R*1000*p1[1]*T*r[i]*(1e-6)));
CCS[i]=e^((2*m[2]*it[2])/(n[2]*R*1000*p1[2]*T*r[i]*(1e-6)));
pB[i]=(CCB[i]-1)*100;
pS[i]=(CCS[i]-1)*100;
end for;

end Ex15_2;
//===============
