//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.3 Page 851
//Title:  Theoretical Yield of Crystals
//======================================================

model Ex15_3

//=============
// Parameter Section
 
parameter Real T(unit="K")=283 " Temperature"; 
parameter Real m[2](each unit="kg/kmol")={142,322}" Relative molecular mass for Na20SO4 and Deca-hydrate";
parameter Real c1(unit="kg Na2SO4/kg water")=0.2" Initial Concentration";
parameter Real c2(unit="kg Na2SO4/kg water")=0.09" Solubility";
parameter Real w1(unit="kg")=5000 " Initial Mass of water";
parameter Real E(unit="kg/kg")=0.02 " Water lost by evaporation";

//=============
// Variable Section

Real R " Ratio";
Real y (unit="kg of decahydrate") "Yield ";

//=============
// Equation Section

equation

R=m[2]/m[1];
y=(w1*R) *(c1-c2*(1-E))/(1-c2*(R-1));

end Ex15_3;
//===============
