//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.4- Page 851
//Title:   Yield of Crystals
//======================================================

model Ex15_4

//=============
// Parameter Section
 
parameter Real T[2](each unit="K")={353,302.2} " Solution and Equilibrium Temperature"; 
parameter Real P(unit="kPa")=1.33" Pressure";
parameter Real c1(unit="kg /kg water")=0.667" Initial Concentration";
parameter Real c2(unit="kg /kg water")=0.539" Final Concentration";
parameter Real q(unit="kJ/kg trihydrate")=144 " Heat of crystallisation";
parameter Real Cp(unit="kJ/kg K")=3.5 " Heat capacity of solution";
parameter Real Lh(unit="kJ/kg")=2.46e3 " Latent heat of water";
parameter Real w1(unit="kg/s")=0.56 "  Mass rate of water";
parameter Real m[2](each unit="kg/kmol")={82,136}" Relative molecular mass ";

//=============
// Variable Section

Real R " Ratio";
Real E(unit="kg/kg water") " Amount of water evaporated";
Real y (unit="kg /s") "Yield ";

//=============
// Equation Section

equation

R=m[2]/m[1];
E=((q*R*(c1-c2))+(Cp*(T[1]-T[2])*(1+c1)*(1-c2*(R-1))))/((Lh*(1-c2*(R-1)))-(q*R*c2));
y=(w1*0.6*R) *(c1-c2*(1-E))/(1-c2*(R-1));

end Ex15_4;
//===============
