//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.6- Page 865
//Title:   Crystal production rate
//======================================================

model Ex15_6
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real n(unit="1/m^4")=1e13" Steady nucleation rate";
parameter Real Gd(unit="m/s")=1e-8" Growth rate";
parameter Real Pr(unit="m^3/s")=0.00017" Product removal rate";
parameter Real V(unit="m^3")=4 " Volume of vessel";
parameter Real p1(unit="kg/m^3")=2660 " Density";
parameter Real a=0.6 " Volumetric Shape Factor";

//=============
// Variable Section

Real t(unit="s") " Draw-down time";
Real cs(unit="kg/m^3") " Concentration";
Real Prod(unit="kg/s") " Crystal production rate ";
Real pnr " Percentage nuclei removed by the time they reach 100micro m";
Real tr(unit="s") " Time to grow >100 micro m";
Real Qf(unit="m^3/s") " Liquor flow rate";

//=============
// Equation Section

equation

t=V/Pr;
cs=(6*a*p1*n)*(Gd*t)^4;
Prod=cs*Pr;
pnr=100*(1-(e^(-100*1e-6/(Gd*t))));
(1/0.1)=e^((100*1e-6/(Gd*tr)));
tr=V/(Pr+Qf);

//Value of cs is incorrect due to improper calculation

end Ex15_6;
//===============
