//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-15: Crystallisation
//Example: 15.8- Page 883
//Title:  Sublimation Rates
//======================================================

model Ex15_8

//=============
// Parameter Section
 
parameter Real Pv[2](each unit="kPa")={1.44,0.0023}" Vapour pressure at 423 and 313K";
parameter Real Pt[2](each unit="kPa")={101.5,100}" Total pressures";
parameter Real T[2](each unit="K")={423,313}" Temperatures";
parameter Real G(unit="kg/s")=0.56 " Gas glow rate";
parameter Real M[2](each unit="kg/kmol")={138,29} " Molecular mass of acid and air";

//=============
// Variable Section

Real Sv(unit="kg/s") " Sublimation rate in vaporiser";
Real S(unit="kg/s") " Sublimation rate in condenser";

//=============
// Equation Section

equation

Sv=G*(M[1]/M[2])*(Pv[1]/(Pt[1]-Pv[1]));
S=G*(M[1]/M[2])*(Pv[2]/(Pt[2]-Pv[2]));

end Ex15_8;
//===============
