//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-16: Drying
//Example: 16.3- Page 911
//Title:  Humidity of exit air
//======================================================
model Ex16_3

//=============
// Parameter Section
 
parameter Real Tdat(unit="K")=273" Datum temperature";
parameter Real T1[2](each unit="K")={295,305} " Inlet and Outlet temperature of material";
parameter Real T2[2](each unit="K")={385,310} " Inlet and Outlet temperature of material";
parameter Real ws(unit="kg/s")=0.125" Wet stock";
parameter Real Cp[3](each unit="kJ/kg K")={0.88,1,2.01} " Specific heat of material,dry air & vapour";
parameter Real LHvap(unit="kJ/kg")=2449 " Latent heat of vaporisation";
parameter Real rate(unit="kg/s m^2")=0.0007 " Constant rate of drying";


//=============
// Variable Section

Real mfr[2](each unit="kg/s") " Mass flow rate of water and dry air";
Real hc(unit="kW") " Heat content of the system";
Real wds(unit="kg/s") " Water in the dried solids leaving";
Real wgs(unit="kg/s") " Water evaporated in the gas stream";
Real hwv(unit="kW") " Heat in water vapour";
Real G(unit="kg/s") " Gas flow rate";
Real hds(unit="kW") " Heat contained in the dry solids";
Real was(unit="kg/s") " Water evaporated in the outlet air stream";
Real H(unit="kg/kg dry air") " Humidity of air";

//=============
// Equation Section

equation
mfr[1]=ws*0.4;
mfr[2]=ws-mfr[1]; 
hc=((mfr[1]*4.186)+(mfr[2]*Cp[1]))*(T1[1]-Tdat);
wds=mfr[2]*0.05/(1+mfr[1]);
wgs=mfr[1]-wds;
hwv=wgs*( (Cp[3]*(T2[2]-T1[2])) + (LHvap) + (4.186*(T1[1]-Tdat)) );
hds=((Cp[1]*mfr[2]) + (0.0036*4.186))*(T1[2]-Tdat);

((113.35*G) + 6.05) = (hwv+(37.45*G)) + (hds + (20*G));
was=(0.006*G)+wgs;
H=was/G;

end Ex16_3;
//===============
