//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-16: Drying
//Example: 16.4- Page 922
//Title:  Approximate drying time
//======================================================

model Ex16_4

//=============
// Parameter Section
 
parameter Real mw(unit="kg")=30" Mass of water";
parameter Real ms(unit="kg")=70" Mass of dry solids";
parameter Real s(unit="m^2/kg")=0.03" Drying surface";
parameter Real u(unit="m/s")=1.8 " Velocity";
parameter Real p=15.5 " Moisture percent to be dried";
parameter Real rate(unit="kg/s m^2")=0.0007 " Constant rate of drying";

//=============
// Variable Section

Real w1(unit="kg/kg dry solids") " Initial moisture content ";
Real w2(unit="kg/kg dry solids") " Final moisture content ";
Real b(unit="kg") " Mass of water in the dried solids";
Real wr(unit="kg") " Water to be removed";
Real sa(unit="m^2") " Surface area for drying";
Real t(unit="s") " Time to dry";

//=============
// Equation Section

equation

(100*b)/(ms+b)=p;
w1=mw/ms;
w2=b/ms;
wr=mw-b;
sa=ms*s;
t=wr/(sa*rate);

end Ex16_4;
//===============
