//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-16: Drying
//Example: 16.6- Page 950
//Title:  Diameter of bed
//======================================================

model Ex16_6

//=============
// Parameter Section
 
parameter Real d(unit="m")=0.5e-3" Diameter";
parameter Real mw(unit="kg/s")=1.26" Mass flow rate of water";
parameter Real ms(unit="kg/s")=12.6" Mass flow rate of solids";
parameter Real uf(unit="m/s")=0.61 " Velocity";   //From figure 16.7
parameter Real p1(unit="kg/m^3")=5000" Density of the material";
parameter Real G(unit="kg/s")=8.3 " Value of G";
parameter Real T(unit="K")=340 " Temperature";

//=============
// Variable Section

Real D(unit="m") " Diameter of bed";

//=============
// Equation Section

equation

D=(T*(G+(1.58*mw))/(278*uf))^0.5;

end Ex16_6;
//===============
