//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-18: Ion Exchange
//Example: 18.1 Page 1062
//Title:  Prediction of time t against xs values
//======================================================

model Ex18_1
extends Modelica.Constants;

//=============
// Parameter Section
 
parameter Real t[7](each unit="s")={2,4,10,20,40,60,120} " Time";
parameter Real xr[7](each unit="kg/kg")={ 0.091,0.097,0.105,0.113,0.125,0.128,0.132 }" Increase in mass";
parameter Real Cse (unit="kg/kg")=0.132 " Value of Cs star ";
parameter Real pdr (unit="s")=0.043" Value of pi*pi*D/r*r";

//=============
// Variable Section

Real slope " Value of slope";
Real Cs1[7] " Value of 1-Cs/Csstar";
Real Cs2[7] " Value of 1-(Cs/Csstar)^2";
Real Cs2r1[3](each unit="kg/kg") " Value of Cs for 2r from equation1";
Real Cs2r2[3](each unit="kg/kg") " Value of Cs for 2r from equation2";

//=============
// Equation Section

equation

slope=pdr/4;

for i in 1:7 loop
Cs1[i]=1-(xr[i]/Cse);
Cs2[i]=1-(xr[i]/Cse)^2;
end for;

for i in 1:3 loop
Cs2r1[i]=Cse*(1- (6/(pi*pi))*e^(-slope*t[i*2]));
Cs2r2[i]/Cse=(1- e^(-slope*t[i*2]))^0.5;

end for;

end Ex18_1;
//===============
