//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-3: Motion of particles in a fluid
//Example: 3.1 Page 159
//Title:  Terminal velocity of a spherical particle
//======================================================

model Ex3_1
extends Modelica.Constants;
extends Modelica.Math;

//=============
// Parameter Section

parameter Real d(unit="m") =0.4e-3 " Diameter of the particle";
parameter Real p1(unit="kg/m^3") =820 " Density of oil";
parameter Real p1p(unit="kg/m^3") =7870 " Density of the particle";
parameter Real v1(unit="Pa s") =10e-3 " Viscosity of oil";

//=============
// Variable Section
  
Real Ga " Dimensionless Galileo Number";
Real Re " Reynolds Number";
Real uo(unit="m/s") " Terminal Falling velocity";
  
//=============
// Equation Section

equation

Ga=(2/3)*(d^3)*(p1p-p1)*p1*g_n/(v1^2);
log10(Re)=0.222; // From Table 3.4
Re=uo*d*p1/v1;

end Ex3_1;
//===============
