//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-4: Flow of fluids through granular beds and packed columns
//Example: 4.1 Page 231
//Title:  Pressure in condenser
//======================================================

model Ex4_1
extends Modelica.Constants; 

//=============
// Parameter Section
 
parameter Real HETP(unit="m") =150e-3" Height of theoretical packing";
parameter Real Np=16 " No of plates needed";
parameter Real pr(unit="g/s") =0.5" Product rate";
parameter Real do(unit="m")=0.1 " Diameter";
parameter Real a(unit="m^2/m^3")=800 " Surface Area per unit volume";
parameter Real v1(unit="Pa s")=0.02e-3 " Viscosity";
parameter Real e=0.72 " Holdup";
parameter Real R=8 " Reflux ratio";
parameter Real Ps(unit="N/m^2")=8000 " Pressure";

//=============
// Variable Section

Real Ai(unit="m^2") " Area";
Real vr(unit="g/s") " Vapour rate";
Real G(unit="kg/m^2 s") " Gas flow rate";
Real Re1 " Modified Reynolds No";
Real Rpu1" Value of R1/pu1^2";
Real l(unit="m") " Length";
Real pdP(unit="N/m^2") " Value of integral";
Real Pc(unit="N/m^2", start=1000) " Pressure in condenser";

//=============
// Equation Section

equation

Ai=(pi/4)*(do^2);
vr=(R+1)*pr;
G=vr*1e-3/Ai;
Re1=G/(a*(1-e)*v1);
Rpu1=(4.17/Re1)+0.29;
l=Np*HETP;
pdP=Rpu1*a*(1-e)*(G^2)*l/(e^3);
pdP=4.73e-5*(Ps^2-Pc^2);

end Ex4_1;
//===============
