//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-5: Sedimentation
//Example: 5.1 Page 264
//Title:  Minimum area of thickener
//======================================================

model Ex5_1

//=============
// Parameter Section
 
parameter Real QCp(unit="kg/s") =1.33" Mass rate of feed of solids";
parameter Real p1(unit="kg/m^3")=1000 " Density";
parameter Real Y[5](each unit="kg water/kg solid")={5.0, 4.2, 3.7, 3.1, 2.5} " Concentration";
parameter Real uc[5](each unit="mm/s") ={ 0.20 ,0.12, 0.094, 0.070, 0.05}" Rate of sedimentation";
parameter Real U(unit="kg water/kg solid")=1.5 " Underflow";

//=============
// Variable Section

Real YU[5](each unit="kg water/kg solid") " Water to overflow";
Real YUc[5](each unit="s/m") " Value of Y-U/uc";
Real A(unit="m^2") " Area of thickener";

//=============
// Equation Section

equation

for i in 1:5 loop

YU[i]=Y[i]-U;
YUc[i]=YU[i]/(uc[i]*1e-3);

end for;

A=YUc[3]*QCp/p1;// Taking maximum value of Y-U/uc which is at 3rd position

end Ex5_1;
//===============
