//Coulson & Richardson's Chemical Engineering Volume 2. Particle Technology & Separation Processes, Elsevier India,2002
//Chapter-5: Sedimentation
//Example: 5.2 Page 265
//Title:  Area of tank
//======================================================

model Ex5_2

//=============
// Parameter Section
 
parameter Real H[12](each unit="mm")={900,800,700,600,500,400,300,260,250,220,200,180} " Height of slurry";
parameter Real uc[12](each unit="mm/min") ={13.4,10.76,8.6,6.6,4.9,3.2,1.8,1.21,1.11,0.80,0.60,0.40}" Value of uc";
parameter Real co(unit="kg/m^3")=200 " Initial Concentration";
parameter Real cu(unit="kg/m^3")=1200 " Underflow Concentration";
parameter Real Q(unit="m^3/min")=2 " Feed rate";

//=============
// Variable Section

Real c[12](each unit="kg/m^3") " Concentration";
Real sed[12](each unit="kg/m^3") " Sedimentation Flux";
Real x[12](each unit="m^3/kg") " Value of x";
Real y[12](each unit="kg/m^2s") " Value for tabulation";
Real z[12](each unit="m^2s/kg") " Value for tabulation";
Real A(unit="m^2") " Area of thickener";

//=============
// Equation Section

equation

for i in 1:12 loop

c[i]=co*H[1]/H[i];
sed[i]=c[i]*uc[i]/(60*1000);
x[i]=1000*((1/c[i])-(1/cu));
y[i]=(uc[i]/60)/x[i];
z[i]=1/y[i];

end for;

A=(Q/60)*co*z[8];// Maximum of z occurs at 8th position

end Ex5_2;
//===============
